package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import org.assertj.core.api.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;

/**
 * Abstract base class for {@link APIGroup} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAPIGroupAssert<S extends AbstractAPIGroupAssert<S, A>, A extends APIGroup> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAPIGroupAssert}</code> to make assertions on actual APIGroup.
   * @param actual the APIGroup we want to make assertions on.
   */
  protected AbstractAPIGroupAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual APIGroup we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual APIGroup we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual APIGroup we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual APIGroup we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property preferredVersion so that assertions can be done on it
   */
  public GroupVersionForDiscoveryAssert preferredVersion()  {
    // check that actual APIGroup we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (GroupVersionForDiscoveryAssert) assertThat(actual.getPreferredVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "preferredVersion"));
  }


  /**
   * Navigates to the property serverAddressByClientCIDRs so that assertions can be done on it
   */
  public NavigationListAssert<ServerAddressByClientCIDR, ServerAddressByClientCIDRAssert> serverAddressByClientCIDRs()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ServerAddressByClientCIDR, ServerAddressByClientCIDRAssert> assertFactory = new AssertFactory<ServerAddressByClientCIDR, ServerAddressByClientCIDRAssert>() {
      public ServerAddressByClientCIDRAssert createAssert(ServerAddressByClientCIDR t) {
        return (ServerAddressByClientCIDRAssert) assertThat(t);
      }
    };
    NavigationListAssert<ServerAddressByClientCIDR, ServerAddressByClientCIDRAssert> answer = new NavigationListAssert<ServerAddressByClientCIDR, ServerAddressByClientCIDRAssert>(actual.getServerAddressByClientCIDRs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serverAddressByClientCIDRs"));
    return answer;
  }


  /**
   * Navigates to the property versions so that assertions can be done on it
   */
  public NavigationListAssert<GroupVersionForDiscovery, GroupVersionForDiscoveryAssert> versions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<GroupVersionForDiscovery, GroupVersionForDiscoveryAssert> assertFactory = new AssertFactory<GroupVersionForDiscovery, GroupVersionForDiscoveryAssert>() {
      public GroupVersionForDiscoveryAssert createAssert(GroupVersionForDiscovery t) {
        return (GroupVersionForDiscoveryAssert) assertThat(t);
      }
    };
    NavigationListAssert<GroupVersionForDiscovery, GroupVersionForDiscoveryAssert> answer = new NavigationListAssert<GroupVersionForDiscovery, GroupVersionForDiscoveryAssert>(actual.getVersions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "versions"));
    return answer;
  }


}
