package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link UserRestriction} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractUserRestrictionAssert<S extends AbstractUserRestrictionAssert<S, A>, A extends UserRestriction> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractUserRestrictionAssert}</code> to make assertions on actual UserRestriction.
   * @param actual the UserRestriction we want to make assertions on.
   */
  protected AbstractUserRestrictionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual UserRestriction we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property groups so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> groups()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getGroups(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "groups"));
    return answer;
  }


  /**
   * Navigates to the property labels so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.LabelSelector, io.fabric8.kubernetes.api.model.LabelSelectorAssert> labels()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.LabelSelector, io.fabric8.kubernetes.api.model.LabelSelectorAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.LabelSelector, io.fabric8.kubernetes.api.model.LabelSelectorAssert>() {
      public io.fabric8.kubernetes.api.model.LabelSelectorAssert createAssert(io.fabric8.kubernetes.api.model.LabelSelector t) {
        return (io.fabric8.kubernetes.api.model.LabelSelectorAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.LabelSelector, io.fabric8.kubernetes.api.model.LabelSelectorAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.LabelSelector, io.fabric8.kubernetes.api.model.LabelSelectorAssert>(actual.getLabels(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "labels"));
    return answer;
  }


  /**
   * Navigates to the property users so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> users()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getUsers(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "users"));
    return answer;
  }


}
