package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link RollingUpdateStatefulSetStrategy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRollingUpdateStatefulSetStrategyAssert<S extends AbstractRollingUpdateStatefulSetStrategyAssert<S, A>, A extends RollingUpdateStatefulSetStrategy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRollingUpdateStatefulSetStrategyAssert}</code> to make assertions on actual RollingUpdateStatefulSetStrategy.
   * @param actual the RollingUpdateStatefulSetStrategy we want to make assertions on.
   */
  protected AbstractRollingUpdateStatefulSetStrategyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual RollingUpdateStatefulSetStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual RollingUpdateStatefulSetStrategy's partition is equal to the given one.
   * @param partition the given partition to compare the actual RollingUpdateStatefulSetStrategy's partition to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RollingUpdateStatefulSetStrategy's partition is not equal to the given one.
   */
  public S hasPartition(Integer partition) {
    // check that actual RollingUpdateStatefulSetStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting partition of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualPartition = actual.getPartition();
    if (!Objects.areEqual(actualPartition, partition)) {
      failWithMessage(assertjErrorMessage, actual, partition, actualPartition);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
