package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ReplicaSetStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractReplicaSetStatusAssert<S extends AbstractReplicaSetStatusAssert<S, A>, A extends ReplicaSetStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractReplicaSetStatusAssert}</code> to make assertions on actual ReplicaSetStatus.
   * @param actual the ReplicaSetStatus we want to make assertions on.
   */
  protected AbstractReplicaSetStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ReplicaSetStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual ReplicaSetStatus's availableReplicas is equal to the given one.
   * @param availableReplicas the given availableReplicas to compare the actual ReplicaSetStatus's availableReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicaSetStatus's availableReplicas is not equal to the given one.
   */
  public S hasAvailableReplicas(Integer availableReplicas) {
    // check that actual ReplicaSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting availableReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualAvailableReplicas = actual.getAvailableReplicas();
    if (!Objects.areEqual(actualAvailableReplicas, availableReplicas)) {
      failWithMessage(assertjErrorMessage, actual, availableReplicas, actualAvailableReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public NavigationListAssert<ReplicaSetCondition, ReplicaSetConditionAssert> conditions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ReplicaSetCondition, ReplicaSetConditionAssert> assertFactory = new AssertFactory<ReplicaSetCondition, ReplicaSetConditionAssert>() {
      public ReplicaSetConditionAssert createAssert(ReplicaSetCondition t) {
        return (ReplicaSetConditionAssert) assertThat(t);
      }
    };
    NavigationListAssert<ReplicaSetCondition, ReplicaSetConditionAssert> answer = new NavigationListAssert<ReplicaSetCondition, ReplicaSetConditionAssert>(actual.getConditions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
    return answer;
  }


  /**
   * Verifies that the actual ReplicaSetStatus's fullyLabeledReplicas is equal to the given one.
   * @param fullyLabeledReplicas the given fullyLabeledReplicas to compare the actual ReplicaSetStatus's fullyLabeledReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicaSetStatus's fullyLabeledReplicas is not equal to the given one.
   */
  public S hasFullyLabeledReplicas(Integer fullyLabeledReplicas) {
    // check that actual ReplicaSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fullyLabeledReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualFullyLabeledReplicas = actual.getFullyLabeledReplicas();
    if (!Objects.areEqual(actualFullyLabeledReplicas, fullyLabeledReplicas)) {
      failWithMessage(assertjErrorMessage, actual, fullyLabeledReplicas, actualFullyLabeledReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicaSetStatus's observedGeneration is equal to the given one.
   * @param observedGeneration the given observedGeneration to compare the actual ReplicaSetStatus's observedGeneration to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicaSetStatus's observedGeneration is not equal to the given one.
   */
  public S hasObservedGeneration(Long observedGeneration) {
    // check that actual ReplicaSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting observedGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualObservedGeneration = actual.getObservedGeneration();
    if (!Objects.areEqual(actualObservedGeneration, observedGeneration)) {
      failWithMessage(assertjErrorMessage, actual, observedGeneration, actualObservedGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicaSetStatus's readyReplicas is equal to the given one.
   * @param readyReplicas the given readyReplicas to compare the actual ReplicaSetStatus's readyReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicaSetStatus's readyReplicas is not equal to the given one.
   */
  public S hasReadyReplicas(Integer readyReplicas) {
    // check that actual ReplicaSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting readyReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReadyReplicas = actual.getReadyReplicas();
    if (!Objects.areEqual(actualReadyReplicas, readyReplicas)) {
      failWithMessage(assertjErrorMessage, actual, readyReplicas, actualReadyReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicaSetStatus's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual ReplicaSetStatus's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicaSetStatus's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual ReplicaSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
