package io.fabric8.kubernetes.api.model.authentication;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link TokenReviewStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTokenReviewStatusAssert<S extends AbstractTokenReviewStatusAssert<S, A>, A extends TokenReviewStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTokenReviewStatusAssert}</code> to make assertions on actual TokenReviewStatus.
   * @param actual the TokenReviewStatus we want to make assertions on.
   */
  protected AbstractTokenReviewStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual TokenReviewStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property authenticated so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert authenticated()  {
    // check that actual TokenReviewStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAuthenticated()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "authenticated"));
  }


  /**
   * Navigates to the property error so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert error()  {
    // check that actual TokenReviewStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getError()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "error"));
  }


  /**
   * Navigates to the property user so that assertions can be done on it
   */
  public UserInfoAssert user()  {
    // check that actual TokenReviewStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (UserInfoAssert) assertThat(actual.getUser()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "user"));
  }


}
