package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link WeightedPodAffinityTerm} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractWeightedPodAffinityTermAssert<S extends AbstractWeightedPodAffinityTermAssert<S, A>, A extends WeightedPodAffinityTerm> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractWeightedPodAffinityTermAssert}</code> to make assertions on actual WeightedPodAffinityTerm.
   * @param actual the WeightedPodAffinityTerm we want to make assertions on.
   */
  protected AbstractWeightedPodAffinityTermAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual WeightedPodAffinityTerm we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property podAffinityTerm so that assertions can be done on it
   */
  public PodAffinityTermAssert podAffinityTerm()  {
    // check that actual WeightedPodAffinityTerm we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PodAffinityTermAssert) assertThat(actual.getPodAffinityTerm()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podAffinityTerm"));
  }


  /**
   * Verifies that the actual WeightedPodAffinityTerm's weight is equal to the given one.
   * @param weight the given weight to compare the actual WeightedPodAffinityTerm's weight to.
   * @return this assertion object.
   * @throws AssertionError - if the actual WeightedPodAffinityTerm's weight is not equal to the given one.
   */
  public S hasWeight(Integer weight) {
    // check that actual WeightedPodAffinityTerm we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting weight of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualWeight = actual.getWeight();
    if (!Objects.areEqual(actualWeight, weight)) {
      failWithMessage(assertjErrorMessage, actual, weight, actualWeight);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
