package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link PodAntiAffinity} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodAntiAffinityAssert<S extends AbstractPodAntiAffinityAssert<S, A>, A extends PodAntiAffinity> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodAntiAffinityAssert}</code> to make assertions on actual PodAntiAffinity.
   * @param actual the PodAntiAffinity we want to make assertions on.
   */
  protected AbstractPodAntiAffinityAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PodAntiAffinity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property preferredDuringSchedulingIgnoredDuringExecution so that assertions can be done on it
   */
  public NavigationListAssert<WeightedPodAffinityTerm, WeightedPodAffinityTermAssert> preferredDuringSchedulingIgnoredDuringExecution()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<WeightedPodAffinityTerm, WeightedPodAffinityTermAssert> assertFactory = new AssertFactory<WeightedPodAffinityTerm, WeightedPodAffinityTermAssert>() {
      public WeightedPodAffinityTermAssert createAssert(WeightedPodAffinityTerm t) {
        return (WeightedPodAffinityTermAssert) assertThat(t);
      }
    };
    NavigationListAssert<WeightedPodAffinityTerm, WeightedPodAffinityTermAssert> answer = new NavigationListAssert<WeightedPodAffinityTerm, WeightedPodAffinityTermAssert>(actual.getPreferredDuringSchedulingIgnoredDuringExecution(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "preferredDuringSchedulingIgnoredDuringExecution"));
    return answer;
  }


  /**
   * Navigates to the property requiredDuringSchedulingIgnoredDuringExecution so that assertions can be done on it
   */
  public NavigationListAssert<PodAffinityTerm, PodAffinityTermAssert> requiredDuringSchedulingIgnoredDuringExecution()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<PodAffinityTerm, PodAffinityTermAssert> assertFactory = new AssertFactory<PodAffinityTerm, PodAffinityTermAssert>() {
      public PodAffinityTermAssert createAssert(PodAffinityTerm t) {
        return (PodAffinityTermAssert) assertThat(t);
      }
    };
    NavigationListAssert<PodAffinityTerm, PodAffinityTermAssert> answer = new NavigationListAssert<PodAffinityTerm, PodAffinityTermAssert>(actual.getRequiredDuringSchedulingIgnoredDuringExecution(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "requiredDuringSchedulingIgnoredDuringExecution"));
    return answer;
  }


}
