/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import io.fabric8.openshift.api.model.StageInfo;
import io.fabric8.openshift.api.model.StepInfo;
import io.fabric8.openshift.api.model.StepInfoAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractStageInfoAssert<S extends AbstractStageInfoAssert<S, A>, A extends StageInfo>
extends AbstractAssert<S, A> {
    protected AbstractStageInfoAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((StageInfo)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public S hasDurationMilliseconds(Long durationMilliseconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting durationMilliseconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualDurationMilliseconds = ((StageInfo)this.actual).getDurationMilliseconds();
        if (!Objects.areEqual((Object)actualDurationMilliseconds, (Object)durationMilliseconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, durationMilliseconds, actualDurationMilliseconds});
        }
        return (S)((Object)((AbstractStageInfoAssert)this.myself));
    }

    public StringAssert name() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((StageInfo)this.actual).getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"), new Object[0]);
    }

    public StringAssert startTime() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((StageInfo)this.actual).getStartTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "startTime"), new Object[0]);
    }

    public NavigationListAssert<StepInfo, StepInfoAssert> steps() {
        this.isNotNull();
        AssertFactory<StepInfo, StepInfoAssert> assertFactory = new AssertFactory<StepInfo, StepInfoAssert>(){

            @Override
            public StepInfoAssert createAssert(StepInfo t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<StepInfo, StepInfoAssert> answer = new NavigationListAssert<StepInfo, StepInfoAssert>(((StageInfo)this.actual).getSteps(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "steps"), new Object[0]);
        return answer;
    }
}

