package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link StageInfo} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStageInfoAssert<S extends AbstractStageInfoAssert<S, A>, A extends StageInfo> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStageInfoAssert}</code> to make assertions on actual StageInfo.
   * @param actual the StageInfo we want to make assertions on.
   */
  protected AbstractStageInfoAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual StageInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual StageInfo's durationMilliseconds is equal to the given one.
   * @param durationMilliseconds the given durationMilliseconds to compare the actual StageInfo's durationMilliseconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StageInfo's durationMilliseconds is not equal to the given one.
   */
  public S hasDurationMilliseconds(Long durationMilliseconds) {
    // check that actual StageInfo we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting durationMilliseconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualDurationMilliseconds = actual.getDurationMilliseconds();
    if (!Objects.areEqual(actualDurationMilliseconds, durationMilliseconds)) {
      failWithMessage(assertjErrorMessage, actual, durationMilliseconds, actualDurationMilliseconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual StageInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property startTime so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert startTime()  {
    // check that actual StageInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStartTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "startTime"));
  }


  /**
   * Navigates to the property steps so that assertions can be done on it
   */
  public NavigationListAssert<StepInfo, StepInfoAssert> steps()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<StepInfo, StepInfoAssert> assertFactory = new AssertFactory<StepInfo, StepInfoAssert>() {
      public StepInfoAssert createAssert(StepInfo t) {
        return (StepInfoAssert) assertThat(t);
      }
    };
    NavigationListAssert<StepInfo, StepInfoAssert> answer = new NavigationListAssert<StepInfo, StepInfoAssert>(actual.getSteps(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "steps"));
    return answer;
  }


}
