package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link DaemonSetUpdateStrategy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDaemonSetUpdateStrategyAssert<S extends AbstractDaemonSetUpdateStrategyAssert<S, A>, A extends DaemonSetUpdateStrategy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDaemonSetUpdateStrategyAssert}</code> to make assertions on actual DaemonSetUpdateStrategy.
   * @param actual the DaemonSetUpdateStrategy we want to make assertions on.
   */
  protected AbstractDaemonSetUpdateStrategyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DaemonSetUpdateStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property rollingUpdate so that assertions can be done on it
   */
  public RollingUpdateDaemonSetAssert rollingUpdate()  {
    // check that actual DaemonSetUpdateStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RollingUpdateDaemonSetAssert) assertThat(actual.getRollingUpdate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "rollingUpdate"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual DaemonSetUpdateStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
