package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ProjectedVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractProjectedVolumeSourceAssert<S extends AbstractProjectedVolumeSourceAssert<S, A>, A extends ProjectedVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProjectedVolumeSourceAssert}</code> to make assertions on actual ProjectedVolumeSource.
   * @param actual the ProjectedVolumeSource we want to make assertions on.
   */
  protected AbstractProjectedVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ProjectedVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual ProjectedVolumeSource's defaultMode is equal to the given one.
   * @param defaultMode the given defaultMode to compare the actual ProjectedVolumeSource's defaultMode to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProjectedVolumeSource's defaultMode is not equal to the given one.
   */
  public S hasDefaultMode(Integer defaultMode) {
    // check that actual ProjectedVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting defaultMode of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualDefaultMode = actual.getDefaultMode();
    if (!Objects.areEqual(actualDefaultMode, defaultMode)) {
      failWithMessage(assertjErrorMessage, actual, defaultMode, actualDefaultMode);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property sources so that assertions can be done on it
   */
  public NavigationListAssert<VolumeProjection, VolumeProjectionAssert> sources()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<VolumeProjection, VolumeProjectionAssert> assertFactory = new AssertFactory<VolumeProjection, VolumeProjectionAssert>() {
      public VolumeProjectionAssert createAssert(VolumeProjection t) {
        return (VolumeProjectionAssert) assertThat(t);
      }
    };
    NavigationListAssert<VolumeProjection, VolumeProjectionAssert> answer = new NavigationListAssert<VolumeProjection, VolumeProjectionAssert>(actual.getSources(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "sources"));
    return answer;
  }


}
