package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link PersistentVolumeClaimSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPersistentVolumeClaimSpecAssert<S extends AbstractPersistentVolumeClaimSpecAssert<S, A>, A extends PersistentVolumeClaimSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPersistentVolumeClaimSpecAssert}</code> to make assertions on actual PersistentVolumeClaimSpec.
   * @param actual the PersistentVolumeClaimSpec we want to make assertions on.
   */
  protected AbstractPersistentVolumeClaimSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property accessModes so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> accessModes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getAccessModes(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "accessModes"));
    return answer;
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PersistentVolumeClaimSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property resources so that assertions can be done on it
   */
  public ResourceRequirementsAssert resources()  {
    // check that actual PersistentVolumeClaimSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ResourceRequirementsAssert) assertThat(actual.getResources()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resources"));
  }


  /**
   * Navigates to the property selector so that assertions can be done on it
   */
  public LabelSelectorAssert selector()  {
    // check that actual PersistentVolumeClaimSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LabelSelectorAssert) assertThat(actual.getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"));
  }


  /**
   * Navigates to the property storageClassName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert storageClassName()  {
    // check that actual PersistentVolumeClaimSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStorageClassName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "storageClassName"));
  }


  /**
   * Navigates to the property volumeName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert volumeName()  {
    // check that actual PersistentVolumeClaimSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVolumeName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeName"));
  }


}
