package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link NodeSelectorTerm} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeSelectorTermAssert<S extends AbstractNodeSelectorTermAssert<S, A>, A extends NodeSelectorTerm> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeSelectorTermAssert}</code> to make assertions on actual NodeSelectorTerm.
   * @param actual the NodeSelectorTerm we want to make assertions on.
   */
  protected AbstractNodeSelectorTermAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NodeSelectorTerm we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property matchExpressions so that assertions can be done on it
   */
  public NavigationListAssert<NodeSelectorRequirement, NodeSelectorRequirementAssert> matchExpressions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NodeSelectorRequirement, NodeSelectorRequirementAssert> assertFactory = new AssertFactory<NodeSelectorRequirement, NodeSelectorRequirementAssert>() {
      public NodeSelectorRequirementAssert createAssert(NodeSelectorRequirement t) {
        return (NodeSelectorRequirementAssert) assertThat(t);
      }
    };
    NavigationListAssert<NodeSelectorRequirement, NodeSelectorRequirementAssert> answer = new NavigationListAssert<NodeSelectorRequirement, NodeSelectorRequirementAssert>(actual.getMatchExpressions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "matchExpressions"));
    return answer;
  }


}
