package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link IntOrString} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIntOrStringAssert<S extends AbstractIntOrStringAssert<S, A>, A extends IntOrString> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIntOrStringAssert}</code> to make assertions on actual IntOrString.
   * @param actual the IntOrString we want to make assertions on.
   */
  protected AbstractIntOrStringAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual IntOrString we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual IntOrString's intVal is equal to the given one.
   * @param intVal the given intVal to compare the actual IntOrString's intVal to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IntOrString's intVal is not equal to the given one.
   */
  public S hasIntVal(Integer intVal) {
    // check that actual IntOrString we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting intVal of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualIntVal = actual.getIntVal();
    if (!Objects.areEqual(actualIntVal, intVal)) {
      failWithMessage(assertjErrorMessage, actual, intVal, actualIntVal);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IntOrString's kind is equal to the given one.
   * @param kind the given kind to compare the actual IntOrString's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IntOrString's kind is not equal to the given one.
   */
  public S hasKind(Integer kind) {
    // check that actual IntOrString we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property strVal so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert strVal()  {
    // check that actual IntOrString we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStrVal()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "strVal"));
  }


}
