package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link DockerBuildStrategy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDockerBuildStrategyAssert<S extends AbstractDockerBuildStrategyAssert<S, A>, A extends DockerBuildStrategy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDockerBuildStrategyAssert}</code> to make assertions on actual DockerBuildStrategy.
   * @param actual the DockerBuildStrategy we want to make assertions on.
   */
  protected AbstractDockerBuildStrategyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property buildArgs so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> buildArgs()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert>() {
      public io.fabric8.kubernetes.api.model.EnvVarAssert createAssert(io.fabric8.kubernetes.api.model.EnvVar t) {
        return (io.fabric8.kubernetes.api.model.EnvVarAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert>(actual.getBuildArgs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "buildArgs"));
    return answer;
  }


  /**
   * Navigates to the property dockerfilePath so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert dockerfilePath()  {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDockerfilePath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dockerfilePath"));
  }


  /**
   * Navigates to the property env so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> env()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert>() {
      public io.fabric8.kubernetes.api.model.EnvVarAssert createAssert(io.fabric8.kubernetes.api.model.EnvVar t) {
        return (io.fabric8.kubernetes.api.model.EnvVarAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert>(actual.getEnv(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "env"));
    return answer;
  }


  /**
   * Navigates to the property forcePull so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert forcePull()  {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getForcePull()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "forcePull"));
  }


  /**
   * Navigates to the property from so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert from()  {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getFrom()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "from"));
  }


  /**
   * Navigates to the property imageOptimizationPolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert imageOptimizationPolicy()  {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getImageOptimizationPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageOptimizationPolicy"));
  }


  /**
   * Navigates to the property noCache so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert noCache()  {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getNoCache()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "noCache"));
  }


  /**
   * Navigates to the property pullSecret so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert pullSecret()  {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert) assertThat(actual.getPullSecret()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "pullSecret"));
  }


}
