package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link NetworkPolicySpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNetworkPolicySpecAssert<S extends AbstractNetworkPolicySpecAssert<S, A>, A extends NetworkPolicySpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNetworkPolicySpecAssert}</code> to make assertions on actual NetworkPolicySpec.
   * @param actual the NetworkPolicySpec we want to make assertions on.
   */
  protected AbstractNetworkPolicySpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NetworkPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property ingress so that assertions can be done on it
   */
  public NavigationListAssert<NetworkPolicyIngressRule, NetworkPolicyIngressRuleAssert> ingress()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NetworkPolicyIngressRule, NetworkPolicyIngressRuleAssert> assertFactory = new AssertFactory<NetworkPolicyIngressRule, NetworkPolicyIngressRuleAssert>() {
      public NetworkPolicyIngressRuleAssert createAssert(NetworkPolicyIngressRule t) {
        return (NetworkPolicyIngressRuleAssert) assertThat(t);
      }
    };
    NavigationListAssert<NetworkPolicyIngressRule, NetworkPolicyIngressRuleAssert> answer = new NavigationListAssert<NetworkPolicyIngressRule, NetworkPolicyIngressRuleAssert>(actual.getIngress(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ingress"));
    return answer;
  }


  /**
   * Navigates to the property podSelector so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LabelSelectorAssert podSelector()  {
    // check that actual NetworkPolicySpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LabelSelectorAssert) assertThat(actual.getPodSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podSelector"));
  }


}
