package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link DaemonSetStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDaemonSetStatusAssert<S extends AbstractDaemonSetStatusAssert<S, A>, A extends DaemonSetStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDaemonSetStatusAssert}</code> to make assertions on actual DaemonSetStatus.
   * @param actual the DaemonSetStatus we want to make assertions on.
   */
  protected AbstractDaemonSetStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DaemonSetStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual DaemonSetStatus's collisionCount is equal to the given one.
   * @param collisionCount the given collisionCount to compare the actual DaemonSetStatus's collisionCount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetStatus's collisionCount is not equal to the given one.
   */
  public S hasCollisionCount(Long collisionCount) {
    // check that actual DaemonSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting collisionCount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualCollisionCount = actual.getCollisionCount();
    if (!Objects.areEqual(actualCollisionCount, collisionCount)) {
      failWithMessage(assertjErrorMessage, actual, collisionCount, actualCollisionCount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetStatus's currentNumberScheduled is equal to the given one.
   * @param currentNumberScheduled the given currentNumberScheduled to compare the actual DaemonSetStatus's currentNumberScheduled to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetStatus's currentNumberScheduled is not equal to the given one.
   */
  public S hasCurrentNumberScheduled(Integer currentNumberScheduled) {
    // check that actual DaemonSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting currentNumberScheduled of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCurrentNumberScheduled = actual.getCurrentNumberScheduled();
    if (!Objects.areEqual(actualCurrentNumberScheduled, currentNumberScheduled)) {
      failWithMessage(assertjErrorMessage, actual, currentNumberScheduled, actualCurrentNumberScheduled);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetStatus's desiredNumberScheduled is equal to the given one.
   * @param desiredNumberScheduled the given desiredNumberScheduled to compare the actual DaemonSetStatus's desiredNumberScheduled to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetStatus's desiredNumberScheduled is not equal to the given one.
   */
  public S hasDesiredNumberScheduled(Integer desiredNumberScheduled) {
    // check that actual DaemonSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting desiredNumberScheduled of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualDesiredNumberScheduled = actual.getDesiredNumberScheduled();
    if (!Objects.areEqual(actualDesiredNumberScheduled, desiredNumberScheduled)) {
      failWithMessage(assertjErrorMessage, actual, desiredNumberScheduled, actualDesiredNumberScheduled);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetStatus's numberAvailable is equal to the given one.
   * @param numberAvailable the given numberAvailable to compare the actual DaemonSetStatus's numberAvailable to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetStatus's numberAvailable is not equal to the given one.
   */
  public S hasNumberAvailable(Integer numberAvailable) {
    // check that actual DaemonSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting numberAvailable of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualNumberAvailable = actual.getNumberAvailable();
    if (!Objects.areEqual(actualNumberAvailable, numberAvailable)) {
      failWithMessage(assertjErrorMessage, actual, numberAvailable, actualNumberAvailable);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetStatus's numberMisscheduled is equal to the given one.
   * @param numberMisscheduled the given numberMisscheduled to compare the actual DaemonSetStatus's numberMisscheduled to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetStatus's numberMisscheduled is not equal to the given one.
   */
  public S hasNumberMisscheduled(Integer numberMisscheduled) {
    // check that actual DaemonSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting numberMisscheduled of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualNumberMisscheduled = actual.getNumberMisscheduled();
    if (!Objects.areEqual(actualNumberMisscheduled, numberMisscheduled)) {
      failWithMessage(assertjErrorMessage, actual, numberMisscheduled, actualNumberMisscheduled);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetStatus's numberReady is equal to the given one.
   * @param numberReady the given numberReady to compare the actual DaemonSetStatus's numberReady to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetStatus's numberReady is not equal to the given one.
   */
  public S hasNumberReady(Integer numberReady) {
    // check that actual DaemonSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting numberReady of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualNumberReady = actual.getNumberReady();
    if (!Objects.areEqual(actualNumberReady, numberReady)) {
      failWithMessage(assertjErrorMessage, actual, numberReady, actualNumberReady);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetStatus's numberUnavailable is equal to the given one.
   * @param numberUnavailable the given numberUnavailable to compare the actual DaemonSetStatus's numberUnavailable to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetStatus's numberUnavailable is not equal to the given one.
   */
  public S hasNumberUnavailable(Integer numberUnavailable) {
    // check that actual DaemonSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting numberUnavailable of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualNumberUnavailable = actual.getNumberUnavailable();
    if (!Objects.areEqual(actualNumberUnavailable, numberUnavailable)) {
      failWithMessage(assertjErrorMessage, actual, numberUnavailable, actualNumberUnavailable);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetStatus's observedGeneration is equal to the given one.
   * @param observedGeneration the given observedGeneration to compare the actual DaemonSetStatus's observedGeneration to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetStatus's observedGeneration is not equal to the given one.
   */
  public S hasObservedGeneration(Long observedGeneration) {
    // check that actual DaemonSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting observedGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualObservedGeneration = actual.getObservedGeneration();
    if (!Objects.areEqual(actualObservedGeneration, observedGeneration)) {
      failWithMessage(assertjErrorMessage, actual, observedGeneration, actualObservedGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetStatus's updatedNumberScheduled is equal to the given one.
   * @param updatedNumberScheduled the given updatedNumberScheduled to compare the actual DaemonSetStatus's updatedNumberScheduled to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetStatus's updatedNumberScheduled is not equal to the given one.
   */
  public S hasUpdatedNumberScheduled(Integer updatedNumberScheduled) {
    // check that actual DaemonSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting updatedNumberScheduled of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualUpdatedNumberScheduled = actual.getUpdatedNumberScheduled();
    if (!Objects.areEqual(actualUpdatedNumberScheduled, updatedNumberScheduled)) {
      failWithMessage(assertjErrorMessage, actual, updatedNumberScheduled, actualUpdatedNumberScheduled);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
