package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link DaemonSetSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDaemonSetSpecAssert<S extends AbstractDaemonSetSpecAssert<S, A>, A extends DaemonSetSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDaemonSetSpecAssert}</code> to make assertions on actual DaemonSetSpec.
   * @param actual the DaemonSetSpec we want to make assertions on.
   */
  protected AbstractDaemonSetSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DaemonSetSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual DaemonSetSpec's minReadySeconds is equal to the given one.
   * @param minReadySeconds the given minReadySeconds to compare the actual DaemonSetSpec's minReadySeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetSpec's minReadySeconds is not equal to the given one.
   */
  public S hasMinReadySeconds(Integer minReadySeconds) {
    // check that actual DaemonSetSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting minReadySeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualMinReadySeconds = actual.getMinReadySeconds();
    if (!Objects.areEqual(actualMinReadySeconds, minReadySeconds)) {
      failWithMessage(assertjErrorMessage, actual, minReadySeconds, actualMinReadySeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetSpec's revisionHistoryLimit is equal to the given one.
   * @param revisionHistoryLimit the given revisionHistoryLimit to compare the actual DaemonSetSpec's revisionHistoryLimit to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetSpec's revisionHistoryLimit is not equal to the given one.
   */
  public S hasRevisionHistoryLimit(Integer revisionHistoryLimit) {
    // check that actual DaemonSetSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting revisionHistoryLimit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualRevisionHistoryLimit = actual.getRevisionHistoryLimit();
    if (!Objects.areEqual(actualRevisionHistoryLimit, revisionHistoryLimit)) {
      failWithMessage(assertjErrorMessage, actual, revisionHistoryLimit, actualRevisionHistoryLimit);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property selector so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LabelSelectorAssert selector()  {
    // check that actual DaemonSetSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LabelSelectorAssert) assertThat(actual.getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"));
  }


  /**
   * Navigates to the property template so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.PodTemplateSpecAssert template()  {
    // check that actual DaemonSetSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.PodTemplateSpecAssert) assertThat(actual.getTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "template"));
  }


  /**
   * Verifies that the actual DaemonSetSpec's templateGeneration is equal to the given one.
   * @param templateGeneration the given templateGeneration to compare the actual DaemonSetSpec's templateGeneration to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetSpec's templateGeneration is not equal to the given one.
   */
  public S hasTemplateGeneration(Long templateGeneration) {
    // check that actual DaemonSetSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting templateGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualTemplateGeneration = actual.getTemplateGeneration();
    if (!Objects.areEqual(actualTemplateGeneration, templateGeneration)) {
      failWithMessage(assertjErrorMessage, actual, templateGeneration, actualTemplateGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property updateStrategy so that assertions can be done on it
   */
  public DaemonSetUpdateStrategyAssert updateStrategy()  {
    // check that actual DaemonSetSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DaemonSetUpdateStrategyAssert) assertThat(actual.getUpdateStrategy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "updateStrategy"));
  }


}
