package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Taint} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTaintAssert<S extends AbstractTaintAssert<S, A>, A extends Taint> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTaintAssert}</code> to make assertions on actual Taint.
   * @param actual the Taint we want to make assertions on.
   */
  protected AbstractTaintAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Taint we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property effect so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert effect()  {
    // check that actual Taint we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getEffect()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "effect"));
  }


  /**
   * Navigates to the property key so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert key()  {
    // check that actual Taint we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKey()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "key"));
  }


  /**
   * Navigates to the property timeAdded so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert timeAdded()  {
    // check that actual Taint we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTimeAdded()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "timeAdded"));
  }


  /**
   * Navigates to the property value so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert value()  {
    // check that actual Taint we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getValue()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "value"));
  }


}
