package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link SecretProjection} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecretProjectionAssert<S extends AbstractSecretProjectionAssert<S, A>, A extends SecretProjection> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecretProjectionAssert}</code> to make assertions on actual SecretProjection.
   * @param actual the SecretProjection we want to make assertions on.
   */
  protected AbstractSecretProjectionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SecretProjection we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property items so that assertions can be done on it
   */
  public NavigationListAssert<KeyToPath, KeyToPathAssert> items()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<KeyToPath, KeyToPathAssert> assertFactory = new AssertFactory<KeyToPath, KeyToPathAssert>() {
      public KeyToPathAssert createAssert(KeyToPath t) {
        return (KeyToPathAssert) assertThat(t);
      }
    };
    NavigationListAssert<KeyToPath, KeyToPathAssert> answer = new NavigationListAssert<KeyToPath, KeyToPathAssert>(actual.getItems(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "items"));
    return answer;
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual SecretProjection we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property optional so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert optional()  {
    // check that actual SecretProjection we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getOptional()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "optional"));
  }


}
