package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Initializers} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractInitializersAssert<S extends AbstractInitializersAssert<S, A>, A extends Initializers> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractInitializersAssert}</code> to make assertions on actual Initializers.
   * @param actual the Initializers we want to make assertions on.
   */
  protected AbstractInitializersAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Initializers we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property pending so that assertions can be done on it
   */
  public NavigationListAssert<Initializer, InitializerAssert> pending()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<Initializer, InitializerAssert> assertFactory = new AssertFactory<Initializer, InitializerAssert>() {
      public InitializerAssert createAssert(Initializer t) {
        return (InitializerAssert) assertThat(t);
      }
    };
    NavigationListAssert<Initializer, InitializerAssert> answer = new NavigationListAssert<Initializer, InitializerAssert>(actual.getPending(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "pending"));
    return answer;
  }


  /**
   * Navigates to the property result so that assertions can be done on it
   */
  public StatusAssert result()  {
    // check that actual Initializers we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (StatusAssert) assertThat(actual.getResult()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "result"));
  }


}
