/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.LabelSelectorAssert;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert;
import io.fabric8.kubernetes.api.model.PodTemplateSpecAssert;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetUpdateStrategyAssert;
import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractStatefulSetSpecAssert<S extends AbstractStatefulSetSpecAssert<S, A>, A extends StatefulSetSpec>
extends AbstractAssert<S, A> {
    protected AbstractStatefulSetSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((StatefulSetSpec)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public StringAssert podManagementPolicy() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((StatefulSetSpec)this.actual).getPodManagementPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podManagementPolicy"), new Object[0]);
    }

    public S hasReplicas(Integer replicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualReplicas = ((StatefulSetSpec)this.actual).getReplicas();
        if (!Objects.areEqual((Object)actualReplicas, (Object)replicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, replicas, actualReplicas});
        }
        return (S)((Object)((AbstractStatefulSetSpecAssert)this.myself));
    }

    public S hasRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting revisionHistoryLimit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualRevisionHistoryLimit = ((StatefulSetSpec)this.actual).getRevisionHistoryLimit();
        if (!Objects.areEqual((Object)actualRevisionHistoryLimit, (Object)revisionHistoryLimit)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, revisionHistoryLimit, actualRevisionHistoryLimit});
        }
        return (S)((Object)((AbstractStatefulSetSpecAssert)this.myself));
    }

    public LabelSelectorAssert selector() {
        this.isNotNull();
        return (LabelSelectorAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((StatefulSetSpec)this.actual).getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"), new Object[0]);
    }

    public StringAssert serviceName() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((StatefulSetSpec)this.actual).getServiceName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceName"), new Object[0]);
    }

    public PodTemplateSpecAssert template() {
        this.isNotNull();
        return (PodTemplateSpecAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((StatefulSetSpec)this.actual).getTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "template"), new Object[0]);
    }

    public StatefulSetUpdateStrategyAssert updateStrategy() {
        this.isNotNull();
        return (StatefulSetUpdateStrategyAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((StatefulSetSpec)this.actual).getUpdateStrategy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "updateStrategy"), new Object[0]);
    }

    public NavigationListAssert<PersistentVolumeClaim, PersistentVolumeClaimAssert> volumeClaimTemplates() {
        this.isNotNull();
        AssertFactory<PersistentVolumeClaim, PersistentVolumeClaimAssert> assertFactory = new AssertFactory<PersistentVolumeClaim, PersistentVolumeClaimAssert>(){

            @Override
            public PersistentVolumeClaimAssert createAssert(PersistentVolumeClaim t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<PersistentVolumeClaim, PersistentVolumeClaimAssert> answer = new NavigationListAssert<PersistentVolumeClaim, PersistentVolumeClaimAssert>(((StatefulSetSpec)this.actual).getVolumeClaimTemplates(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeClaimTemplates"), new Object[0]);
        return answer;
    }
}

