/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.ContainerStatusAssert;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodConditionAssert;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.TimeAssert;
import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;

public abstract class AbstractPodStatusAssert<S extends AbstractPodStatusAssert<S, A>, A extends PodStatus>
extends AbstractAssert<S, A> {
    protected AbstractPodStatusAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((PodStatus)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public NavigationListAssert<PodCondition, PodConditionAssert> conditions() {
        this.isNotNull();
        AssertFactory<PodCondition, PodConditionAssert> assertFactory = new AssertFactory<PodCondition, PodConditionAssert>(){

            @Override
            public PodConditionAssert createAssert(PodCondition t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<PodCondition, PodConditionAssert> answer = new NavigationListAssert<PodCondition, PodConditionAssert>(((PodStatus)this.actual).getConditions(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"), new Object[0]);
        return answer;
    }

    public NavigationListAssert<ContainerStatus, ContainerStatusAssert> containerStatuses() {
        this.isNotNull();
        AssertFactory<ContainerStatus, ContainerStatusAssert> assertFactory = new AssertFactory<ContainerStatus, ContainerStatusAssert>(){

            @Override
            public ContainerStatusAssert createAssert(ContainerStatus t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<ContainerStatus, ContainerStatusAssert> answer = new NavigationListAssert<ContainerStatus, ContainerStatusAssert>(((PodStatus)this.actual).getContainerStatuses(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containerStatuses"), new Object[0]);
        return answer;
    }

    public StringAssert hostIP() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodStatus)this.actual).getHostIP()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostIP"), new Object[0]);
    }

    public NavigationListAssert<ContainerStatus, ContainerStatusAssert> initContainerStatuses() {
        this.isNotNull();
        AssertFactory<ContainerStatus, ContainerStatusAssert> assertFactory = new AssertFactory<ContainerStatus, ContainerStatusAssert>(){

            @Override
            public ContainerStatusAssert createAssert(ContainerStatus t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<ContainerStatus, ContainerStatusAssert> answer = new NavigationListAssert<ContainerStatus, ContainerStatusAssert>(((PodStatus)this.actual).getInitContainerStatuses(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "initContainerStatuses"), new Object[0]);
        return answer;
    }

    public StringAssert message() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodStatus)this.actual).getMessage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "message"), new Object[0]);
    }

    public StringAssert phase() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodStatus)this.actual).getPhase()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "phase"), new Object[0]);
    }

    public StringAssert podIP() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodStatus)this.actual).getPodIP()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podIP"), new Object[0]);
    }

    public StringAssert qosClass() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodStatus)this.actual).getQosClass()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "qosClass"), new Object[0]);
    }

    public StringAssert reason() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodStatus)this.actual).getReason()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reason"), new Object[0]);
    }

    public TimeAssert startTime() {
        this.isNotNull();
        return (TimeAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((PodStatus)this.actual).getStartTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "startTime"), new Object[0]);
    }
}

