package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link TagImportPolicy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTagImportPolicyAssert<S extends AbstractTagImportPolicyAssert<S, A>, A extends TagImportPolicy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTagImportPolicyAssert}</code> to make assertions on actual TagImportPolicy.
   * @param actual the TagImportPolicy we want to make assertions on.
   */
  protected AbstractTagImportPolicyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual TagImportPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property insecure so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert insecure()  {
    // check that actual TagImportPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getInsecure()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "insecure"));
  }


  /**
   * Navigates to the property scheduled so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert scheduled()  {
    // check that actual TagImportPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getScheduled()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scheduled"));
  }


}
