package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link SupplementalGroupsStrategyOptions} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSupplementalGroupsStrategyOptionsAssert<S extends AbstractSupplementalGroupsStrategyOptionsAssert<S, A>, A extends SupplementalGroupsStrategyOptions> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSupplementalGroupsStrategyOptionsAssert}</code> to make assertions on actual SupplementalGroupsStrategyOptions.
   * @param actual the SupplementalGroupsStrategyOptions we want to make assertions on.
   */
  protected AbstractSupplementalGroupsStrategyOptionsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SupplementalGroupsStrategyOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property ranges so that assertions can be done on it
   */
  public NavigationListAssert<IDRange, IDRangeAssert> ranges()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<IDRange, IDRangeAssert> assertFactory = new AssertFactory<IDRange, IDRangeAssert>() {
      public IDRangeAssert createAssert(IDRange t) {
        return (IDRangeAssert) assertThat(t);
      }
    };
    NavigationListAssert<IDRange, IDRangeAssert> answer = new NavigationListAssert<IDRange, IDRangeAssert>(actual.getRanges(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ranges"));
    return answer;
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual SupplementalGroupsStrategyOptions we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
