package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Policy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPolicyAssert<S extends AbstractPolicyAssert<S, A>, A extends Policy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPolicyAssert}</code> to make assertions on actual Policy.
   * @param actual the Policy we want to make assertions on.
   */
  protected AbstractPolicyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Policy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual Policy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual Policy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property lastModified so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.TimeAssert lastModified()  {
    // check that actual Policy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.TimeAssert) assertThat(actual.getLastModified()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastModified"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual Policy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property roles so that assertions can be done on it
   */
  public NavigationListAssert<NamedRole, NamedRoleAssert> roles()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NamedRole, NamedRoleAssert> assertFactory = new AssertFactory<NamedRole, NamedRoleAssert>() {
      public NamedRoleAssert createAssert(NamedRole t) {
        return (NamedRoleAssert) assertThat(t);
      }
    };
    NavigationListAssert<NamedRole, NamedRoleAssert> answer = new NavigationListAssert<NamedRole, NamedRoleAssert>(actual.getRoles(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "roles"));
    return answer;
  }


}
