package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ImageSignature} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageSignatureAssert<S extends AbstractImageSignatureAssert<S, A>, A extends ImageSignature> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageSignatureAssert}</code> to make assertions on actual ImageSignature.
   * @param actual the ImageSignature we want to make assertions on.
   */
  protected AbstractImageSignatureAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ImageSignature we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual ImageSignature we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public NavigationListAssert<SignatureCondition, SignatureConditionAssert> conditions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<SignatureCondition, SignatureConditionAssert> assertFactory = new AssertFactory<SignatureCondition, SignatureConditionAssert>() {
      public SignatureConditionAssert createAssert(SignatureCondition t) {
        return (SignatureConditionAssert) assertThat(t);
      }
    };
    NavigationListAssert<SignatureCondition, SignatureConditionAssert> answer = new NavigationListAssert<SignatureCondition, SignatureConditionAssert>(actual.getConditions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
    return answer;
  }


  /**
   * Navigates to the property content so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert content()  {
    // check that actual ImageSignature we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getContent()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "content"));
  }


  /**
   * Navigates to the property created so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.TimeAssert created()  {
    // check that actual ImageSignature we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.TimeAssert) assertThat(actual.getCreated()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "created"));
  }


  /**
   * Navigates to the property imageIdentity so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert imageIdentity()  {
    // check that actual ImageSignature we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getImageIdentity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageIdentity"));
  }


  /**
   * Navigates to the property issuedBy so that assertions can be done on it
   */
  public SignatureIssuerAssert issuedBy()  {
    // check that actual ImageSignature we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SignatureIssuerAssert) assertThat(actual.getIssuedBy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "issuedBy"));
  }


  /**
   * Navigates to the property issuedTo so that assertions can be done on it
   */
  public SignatureSubjectAssert issuedTo()  {
    // check that actual ImageSignature we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SignatureSubjectAssert) assertThat(actual.getIssuedTo()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "issuedTo"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual ImageSignature we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual ImageSignature we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property signedClaims so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert signedClaims()  {
    // check that actual ImageSignature we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getSignedClaims()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "signedClaims"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual ImageSignature we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
