package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ScaleIOVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractScaleIOVolumeSourceAssert<S extends AbstractScaleIOVolumeSourceAssert<S, A>, A extends ScaleIOVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractScaleIOVolumeSourceAssert}</code> to make assertions on actual ScaleIOVolumeSource.
   * @param actual the ScaleIOVolumeSource we want to make assertions on.
   */
  protected AbstractScaleIOVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ScaleIOVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property fsType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert fsType()  {
    // check that actual ScaleIOVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFsType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fsType"));
  }


  /**
   * Navigates to the property gateway so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert gateway()  {
    // check that actual ScaleIOVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGateway()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "gateway"));
  }


  /**
   * Navigates to the property protectionDomain so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert protectionDomain()  {
    // check that actual ScaleIOVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getProtectionDomain()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "protectionDomain"));
  }


  /**
   * Navigates to the property readOnly so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnly()  {
    // check that actual ScaleIOVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnly()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnly"));
  }


  /**
   * Navigates to the property secretRef so that assertions can be done on it
   */
  public LocalObjectReferenceAssert secretRef()  {
    // check that actual ScaleIOVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LocalObjectReferenceAssert) assertThat(actual.getSecretRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secretRef"));
  }


  /**
   * Navigates to the property sslEnabled so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert sslEnabled()  {
    // check that actual ScaleIOVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getSslEnabled()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "sslEnabled"));
  }


  /**
   * Navigates to the property storageMode so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert storageMode()  {
    // check that actual ScaleIOVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStorageMode()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "storageMode"));
  }


  /**
   * Navigates to the property storagePool so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert storagePool()  {
    // check that actual ScaleIOVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStoragePool()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "storagePool"));
  }


  /**
   * Navigates to the property system so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert system()  {
    // check that actual ScaleIOVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSystem()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "system"));
  }


  /**
   * Navigates to the property volumeName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert volumeName()  {
    // check that actual ScaleIOVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVolumeName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeName"));
  }


}
