package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link PodSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodSpecAssert<S extends AbstractPodSpecAssert<S, A>, A extends PodSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodSpecAssert}</code> to make assertions on actual PodSpec.
   * @param actual the PodSpec we want to make assertions on.
   */
  protected AbstractPodSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Verifies that the actual PodSpec's activeDeadlineSeconds is equal to the given one.
   * @param activeDeadlineSeconds the given activeDeadlineSeconds to compare the actual PodSpec's activeDeadlineSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpec's activeDeadlineSeconds is not equal to the given one.
   */
  public S hasActiveDeadlineSeconds(Long activeDeadlineSeconds) {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting activeDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualActiveDeadlineSeconds = actual.getActiveDeadlineSeconds();
    if (!Objects.areEqual(actualActiveDeadlineSeconds, activeDeadlineSeconds)) {
      failWithMessage(assertjErrorMessage, actual, activeDeadlineSeconds, actualActiveDeadlineSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property affinity so that assertions can be done on it
   */
  public AffinityAssert affinity()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (AffinityAssert) assertThat(actual.getAffinity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "affinity"));
  }


  /**
   * Navigates to the property automountServiceAccountToken so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert automountServiceAccountToken()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAutomountServiceAccountToken()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "automountServiceAccountToken"));
  }


  /**
   * Navigates to the property containers so that assertions can be done on it
   */
  public NavigationListAssert<Container, ContainerAssert> containers()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<Container, ContainerAssert> assertFactory = new AssertFactory<Container, ContainerAssert>() {
      public ContainerAssert createAssert(Container t) {
        return (ContainerAssert) assertThat(t);
      }
    };
    NavigationListAssert<Container, ContainerAssert> answer = new NavigationListAssert<Container, ContainerAssert>(actual.getContainers(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containers"));
    return answer;
  }


  /**
   * Navigates to the property dnsPolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert dnsPolicy()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDnsPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dnsPolicy"));
  }


  /**
   * Navigates to the property hostAliases so that assertions can be done on it
   */
  public NavigationListAssert<HostAlias, HostAliasAssert> hostAliases()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<HostAlias, HostAliasAssert> assertFactory = new AssertFactory<HostAlias, HostAliasAssert>() {
      public HostAliasAssert createAssert(HostAlias t) {
        return (HostAliasAssert) assertThat(t);
      }
    };
    NavigationListAssert<HostAlias, HostAliasAssert> answer = new NavigationListAssert<HostAlias, HostAliasAssert>(actual.getHostAliases(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostAliases"));
    return answer;
  }


  /**
   * Navigates to the property hostIPC so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert hostIPC()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getHostIPC()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostIPC"));
  }


  /**
   * Navigates to the property hostNetwork so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert hostNetwork()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getHostNetwork()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostNetwork"));
  }


  /**
   * Navigates to the property hostPID so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert hostPID()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getHostPID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostPID"));
  }


  /**
   * Navigates to the property hostname so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert hostname()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHostname()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostname"));
  }


  /**
   * Navigates to the property imagePullSecrets so that assertions can be done on it
   */
  public NavigationListAssert<LocalObjectReference, LocalObjectReferenceAssert> imagePullSecrets()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<LocalObjectReference, LocalObjectReferenceAssert> assertFactory = new AssertFactory<LocalObjectReference, LocalObjectReferenceAssert>() {
      public LocalObjectReferenceAssert createAssert(LocalObjectReference t) {
        return (LocalObjectReferenceAssert) assertThat(t);
      }
    };
    NavigationListAssert<LocalObjectReference, LocalObjectReferenceAssert> answer = new NavigationListAssert<LocalObjectReference, LocalObjectReferenceAssert>(actual.getImagePullSecrets(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imagePullSecrets"));
    return answer;
  }


  /**
   * Navigates to the property initContainers so that assertions can be done on it
   */
  public NavigationListAssert<Container, ContainerAssert> initContainers()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<Container, ContainerAssert> assertFactory = new AssertFactory<Container, ContainerAssert>() {
      public ContainerAssert createAssert(Container t) {
        return (ContainerAssert) assertThat(t);
      }
    };
    NavigationListAssert<Container, ContainerAssert> answer = new NavigationListAssert<Container, ContainerAssert>(actual.getInitContainers(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "initContainers"));
    return answer;
  }


  /**
   * Navigates to the property nodeName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert nodeName()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getNodeName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeName"));
  }


  /**
   * Navigates to the property nodeSelector so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert nodeSelector()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getNodeSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeSelector"));
  }


  /**
   * Navigates to the property restartPolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert restartPolicy()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getRestartPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "restartPolicy"));
  }


  /**
   * Navigates to the property schedulerName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert schedulerName()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSchedulerName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "schedulerName"));
  }


  /**
   * Navigates to the property securityContext so that assertions can be done on it
   */
  public PodSecurityContextAssert securityContext()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PodSecurityContextAssert) assertThat(actual.getSecurityContext()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "securityContext"));
  }


  /**
   * Navigates to the property serviceAccount so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert serviceAccount()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getServiceAccount()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceAccount"));
  }


  /**
   * Navigates to the property serviceAccountName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert serviceAccountName()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getServiceAccountName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceAccountName"));
  }


  /**
   * Navigates to the property subdomain so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert subdomain()  {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSubdomain()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "subdomain"));
  }


  /**
   * Verifies that the actual PodSpec's terminationGracePeriodSeconds is equal to the given one.
   * @param terminationGracePeriodSeconds the given terminationGracePeriodSeconds to compare the actual PodSpec's terminationGracePeriodSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpec's terminationGracePeriodSeconds is not equal to the given one.
   */
  public S hasTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting terminationGracePeriodSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualTerminationGracePeriodSeconds = actual.getTerminationGracePeriodSeconds();
    if (!Objects.areEqual(actualTerminationGracePeriodSeconds, terminationGracePeriodSeconds)) {
      failWithMessage(assertjErrorMessage, actual, terminationGracePeriodSeconds, actualTerminationGracePeriodSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property tolerations so that assertions can be done on it
   */
  public NavigationListAssert<Toleration, TolerationAssert> tolerations()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<Toleration, TolerationAssert> assertFactory = new AssertFactory<Toleration, TolerationAssert>() {
      public TolerationAssert createAssert(Toleration t) {
        return (TolerationAssert) assertThat(t);
      }
    };
    NavigationListAssert<Toleration, TolerationAssert> answer = new NavigationListAssert<Toleration, TolerationAssert>(actual.getTolerations(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tolerations"));
    return answer;
  }


  /**
   * Navigates to the property volumes so that assertions can be done on it
   */
  public NavigationListAssert<Volume, VolumeAssert> volumes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<Volume, VolumeAssert> assertFactory = new AssertFactory<Volume, VolumeAssert>() {
      public VolumeAssert createAssert(Volume t) {
        return (VolumeAssert) assertThat(t);
      }
    };
    NavigationListAssert<Volume, VolumeAssert> answer = new NavigationListAssert<Volume, VolumeAssert>(actual.getVolumes(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumes"));
    return answer;
  }


}
