package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Handler} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractHandlerAssert<S extends AbstractHandlerAssert<S, A>, A extends Handler> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHandlerAssert}</code> to make assertions on actual Handler.
   * @param actual the Handler we want to make assertions on.
   */
  protected AbstractHandlerAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Handler we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property exec so that assertions can be done on it
   */
  public ExecActionAssert exec()  {
    // check that actual Handler we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ExecActionAssert) assertThat(actual.getExec()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "exec"));
  }


  /**
   * Navigates to the property httpGet so that assertions can be done on it
   */
  public HTTPGetActionAssert httpGet()  {
    // check that actual Handler we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (HTTPGetActionAssert) assertThat(actual.getHttpGet()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "httpGet"));
  }


  /**
   * Navigates to the property tcpSocket so that assertions can be done on it
   */
  public TCPSocketActionAssert tcpSocket()  {
    // check that actual Handler we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (TCPSocketActionAssert) assertThat(actual.getTcpSocket()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tcpSocket"));
  }


}
