package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Event} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEventAssert<S extends AbstractEventAssert<S, A>, A extends Event> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEventAssert}</code> to make assertions on actual Event.
   * @param actual the Event we want to make assertions on.
   */
  protected AbstractEventAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Verifies that the actual Event's count is equal to the given one.
   * @param count the given count to compare the actual Event's count to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Event's count is not equal to the given one.
   */
  public S hasCount(Integer count) {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting count of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCount = actual.getCount();
    if (!Objects.areEqual(actualCount, count)) {
      failWithMessage(assertjErrorMessage, actual, count, actualCount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property firstTimestamp so that assertions can be done on it
   */
  public TimeAssert firstTimestamp()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (TimeAssert) assertThat(actual.getFirstTimestamp()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "firstTimestamp"));
  }


  /**
   * Navigates to the property involvedObject so that assertions can be done on it
   */
  public ObjectReferenceAssert involvedObject()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectReferenceAssert) assertThat(actual.getInvolvedObject()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "involvedObject"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property lastTimestamp so that assertions can be done on it
   */
  public TimeAssert lastTimestamp()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (TimeAssert) assertThat(actual.getLastTimestamp()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastTimestamp"));
  }


  /**
   * Navigates to the property message so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert message()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMessage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "message"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public ObjectMetaAssert metadata()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property reason so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert reason()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getReason()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reason"));
  }


  /**
   * Navigates to the property source so that assertions can be done on it
   */
  public EventSourceAssert source()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (EventSourceAssert) assertThat(actual.getSource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "source"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
