package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link EndpointAddress} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEndpointAddressAssert<S extends AbstractEndpointAddressAssert<S, A>, A extends EndpointAddress> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEndpointAddressAssert}</code> to make assertions on actual EndpointAddress.
   * @param actual the EndpointAddress we want to make assertions on.
   */
  protected AbstractEndpointAddressAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual EndpointAddress we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property hostname so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert hostname()  {
    // check that actual EndpointAddress we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHostname()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostname"));
  }


  /**
   * Navigates to the property ip so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert ip()  {
    // check that actual EndpointAddress we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getIp()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ip"));
  }


  /**
   * Navigates to the property nodeName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert nodeName()  {
    // check that actual EndpointAddress we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getNodeName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeName"));
  }


  /**
   * Navigates to the property targetRef so that assertions can be done on it
   */
  public ObjectReferenceAssert targetRef()  {
    // check that actual EndpointAddress we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectReferenceAssert) assertThat(actual.getTargetRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "targetRef"));
  }


}
