package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link EmptyDirVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEmptyDirVolumeSourceAssert<S extends AbstractEmptyDirVolumeSourceAssert<S, A>, A extends EmptyDirVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEmptyDirVolumeSourceAssert}</code> to make assertions on actual EmptyDirVolumeSource.
   * @param actual the EmptyDirVolumeSource we want to make assertions on.
   */
  protected AbstractEmptyDirVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual EmptyDirVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property medium so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert medium()  {
    // check that actual EmptyDirVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMedium()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "medium"));
  }


  /**
   * Navigates to the property sizeLimit so that assertions can be done on it
   */
  public QuantityAssert sizeLimit()  {
    // check that actual EmptyDirVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (QuantityAssert) assertThat(actual.getSizeLimit()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "sizeLimit"));
  }


}
