package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ContainerStateRunning} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerStateRunningAssert<S extends AbstractContainerStateRunningAssert<S, A>, A extends ContainerStateRunning> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerStateRunningAssert}</code> to make assertions on actual ContainerStateRunning.
   * @param actual the ContainerStateRunning we want to make assertions on.
   */
  protected AbstractContainerStateRunningAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ContainerStateRunning we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property startedAt so that assertions can be done on it
   */
  public TimeAssert startedAt()  {
    // check that actual ContainerStateRunning we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (TimeAssert) assertThat(actual.getStartedAt()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "startedAt"));
  }


}
