package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Affinity} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAffinityAssert<S extends AbstractAffinityAssert<S, A>, A extends Affinity> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAffinityAssert}</code> to make assertions on actual Affinity.
   * @param actual the Affinity we want to make assertions on.
   */
  protected AbstractAffinityAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Affinity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property nodeAffinity so that assertions can be done on it
   */
  public NodeAffinityAssert nodeAffinity()  {
    // check that actual Affinity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NodeAffinityAssert) assertThat(actual.getNodeAffinity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeAffinity"));
  }


  /**
   * Navigates to the property podAffinity so that assertions can be done on it
   */
  public PodAffinityAssert podAffinity()  {
    // check that actual Affinity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PodAffinityAssert) assertThat(actual.getPodAffinity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podAffinity"));
  }


  /**
   * Navigates to the property podAntiAffinity so that assertions can be done on it
   */
  public PodAntiAffinityAssert podAntiAffinity()  {
    // check that actual Affinity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PodAntiAffinityAssert) assertThat(actual.getPodAntiAffinity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podAntiAffinity"));
  }


}
