/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.assertions.AbstractPodSelectionAssert;
import io.fabric8.kubernetes.assertions.HasPodSelectionAssert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;

public class MultiHasPodSelectionAssert
implements HasPodSelectionAssert {
    private List<HasPodSelectionAssert> asserters;

    public MultiHasPodSelectionAssert(List<HasPodSelectionAssert> asserters) {
        this.asserters = asserters;
    }

    @Override
    public AbstractPodSelectionAssert pods() {
        return new MultiPodSelectionAssert();
    }

    class MultiPodSelectionAssert
    extends AbstractPodSelectionAssert {
        MultiPodSelectionAssert() {
        }

        @Override
        public List<Pod> getPods() {
            ArrayList<Pod> rc = new ArrayList<Pod>();
            for (HasPodSelectionAssert asserter : MultiHasPodSelectionAssert.this.asserters) {
                for (Pod pod : asserter.pods().getPods()) {
                    rc.add(pod);
                }
            }
            return rc;
        }

        @Override
        public MultiPodSelectionAssert isPodReadyForPeriod(final long notReadyTimeoutMS, final long readyPeriodMS) {
            final AtomicReference failure = new AtomicReference();
            ArrayList<1> threads = new ArrayList<1>(MultiHasPodSelectionAssert.this.asserters.size());
            Iterator iterator = MultiHasPodSelectionAssert.this.asserters.iterator();
            while (iterator.hasNext()) {
                HasPodSelectionAssert hasPodSelectionAssert;
                final HasPodSelectionAssert asserter = hasPodSelectionAssert = (HasPodSelectionAssert)iterator.next();
                Thread thread = new Thread("MultiPodSelectionAssert"){

                    @Override
                    public void run() {
                        try {
                            asserter.pods().isPodReadyForPeriod(notReadyTimeoutMS, readyPeriodMS);
                        }
                        catch (Throwable e) {
                            failure.set(e);
                        }
                    }
                };
                thread.start();
                threads.add(thread);
            }
            for (Thread thread : threads) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    Assertions.fail((String)("Interrupted: " + e));
                }
            }
            Throwable throwable = (Throwable)failure.get();
            if (throwable != null) {
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException(throwable);
            }
            return this;
        }
    }
}

