package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link JenkinsPipelineBuildStrategy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractJenkinsPipelineBuildStrategyAssert<S extends AbstractJenkinsPipelineBuildStrategyAssert<S, A>, A extends JenkinsPipelineBuildStrategy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractJenkinsPipelineBuildStrategyAssert}</code> to make assertions on actual JenkinsPipelineBuildStrategy.
   * @param actual the JenkinsPipelineBuildStrategy we want to make assertions on.
   */
  protected AbstractJenkinsPipelineBuildStrategyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual JenkinsPipelineBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property env so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> env()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert>() {
      public io.fabric8.kubernetes.api.model.EnvVarAssert createAssert(io.fabric8.kubernetes.api.model.EnvVar t) {
        return (io.fabric8.kubernetes.api.model.EnvVarAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.EnvVar, io.fabric8.kubernetes.api.model.EnvVarAssert>(actual.getEnv(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "env"));
    return answer;
  }


  /**
   * Navigates to the property jenkinsfile so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert jenkinsfile()  {
    // check that actual JenkinsPipelineBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getJenkinsfile()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "jenkinsfile"));
  }


  /**
   * Navigates to the property jenkinsfilePath so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert jenkinsfilePath()  {
    // check that actual JenkinsPipelineBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getJenkinsfilePath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "jenkinsfilePath"));
  }


}
