package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link RoleBindingRestrictionSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRoleBindingRestrictionSpecAssert<S extends AbstractRoleBindingRestrictionSpecAssert<S, A>, A extends RoleBindingRestrictionSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRoleBindingRestrictionSpecAssert}</code> to make assertions on actual RoleBindingRestrictionSpec.
   * @param actual the RoleBindingRestrictionSpec we want to make assertions on.
   */
  protected AbstractRoleBindingRestrictionSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual RoleBindingRestrictionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property grouprestriction so that assertions can be done on it
   */
  public GroupRestrictionAssert grouprestriction()  {
    // check that actual RoleBindingRestrictionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (GroupRestrictionAssert) assertThat(actual.getGrouprestriction()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "grouprestriction"));
  }


  /**
   * Navigates to the property serviceaccountrestriction so that assertions can be done on it
   */
  public ServiceAccountRestrictionAssert serviceaccountrestriction()  {
    // check that actual RoleBindingRestrictionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ServiceAccountRestrictionAssert) assertThat(actual.getServiceaccountrestriction()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceaccountrestriction"));
  }


  /**
   * Navigates to the property userrestriction so that assertions can be done on it
   */
  public UserRestrictionAssert userrestriction()  {
    // check that actual RoleBindingRestrictionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (UserRestrictionAssert) assertThat(actual.getUserrestriction()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "userrestriction"));
  }


}
