package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link DeploymentSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentSpecAssert<S extends AbstractDeploymentSpecAssert<S, A>, A extends DeploymentSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentSpecAssert}</code> to make assertions on actual DeploymentSpec.
   * @param actual the DeploymentSpec we want to make assertions on.
   */
  protected AbstractDeploymentSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual DeploymentSpec's minReadySeconds is equal to the given one.
   * @param minReadySeconds the given minReadySeconds to compare the actual DeploymentSpec's minReadySeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpec's minReadySeconds is not equal to the given one.
   */
  public S hasMinReadySeconds(Integer minReadySeconds) {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting minReadySeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualMinReadySeconds = actual.getMinReadySeconds();
    if (!Objects.areEqual(actualMinReadySeconds, minReadySeconds)) {
      failWithMessage(assertjErrorMessage, actual, minReadySeconds, actualMinReadySeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property paused so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert paused()  {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getPaused()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "paused"));
  }


  /**
   * Verifies that the actual DeploymentSpec's progressDeadlineSeconds is equal to the given one.
   * @param progressDeadlineSeconds the given progressDeadlineSeconds to compare the actual DeploymentSpec's progressDeadlineSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpec's progressDeadlineSeconds is not equal to the given one.
   */
  public S hasProgressDeadlineSeconds(Integer progressDeadlineSeconds) {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting progressDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualProgressDeadlineSeconds = actual.getProgressDeadlineSeconds();
    if (!Objects.areEqual(actualProgressDeadlineSeconds, progressDeadlineSeconds)) {
      failWithMessage(assertjErrorMessage, actual, progressDeadlineSeconds, actualProgressDeadlineSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentSpec's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual DeploymentSpec's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpec's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentSpec's revisionHistoryLimit is equal to the given one.
   * @param revisionHistoryLimit the given revisionHistoryLimit to compare the actual DeploymentSpec's revisionHistoryLimit to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpec's revisionHistoryLimit is not equal to the given one.
   */
  public S hasRevisionHistoryLimit(Integer revisionHistoryLimit) {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting revisionHistoryLimit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualRevisionHistoryLimit = actual.getRevisionHistoryLimit();
    if (!Objects.areEqual(actualRevisionHistoryLimit, revisionHistoryLimit)) {
      failWithMessage(assertjErrorMessage, actual, revisionHistoryLimit, actualRevisionHistoryLimit);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property rollbackTo so that assertions can be done on it
   */
  public RollbackConfigAssert rollbackTo()  {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RollbackConfigAssert) assertThat(actual.getRollbackTo()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "rollbackTo"));
  }


  /**
   * Navigates to the property selector so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LabelSelectorAssert selector()  {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LabelSelectorAssert) assertThat(actual.getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"));
  }


  /**
   * Navigates to the property strategy so that assertions can be done on it
   */
  public DeploymentStrategyAssert strategy()  {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DeploymentStrategyAssert) assertThat(actual.getStrategy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "strategy"));
  }


  /**
   * Navigates to the property template so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.PodTemplateSpecAssert template()  {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.PodTemplateSpecAssert) assertThat(actual.getTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "template"));
  }


}
