package io.fabric8.kubernetes.api.model.apiextensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link CustomResourceDefinitionCondition} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomResourceDefinitionConditionAssert<S extends AbstractCustomResourceDefinitionConditionAssert<S, A>, A extends CustomResourceDefinitionCondition> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomResourceDefinitionConditionAssert}</code> to make assertions on actual CustomResourceDefinitionCondition.
   * @param actual the CustomResourceDefinitionCondition we want to make assertions on.
   */
  protected AbstractCustomResourceDefinitionConditionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CustomResourceDefinitionCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property lastTransitionTime so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.TimeAssert lastTransitionTime()  {
    // check that actual CustomResourceDefinitionCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.TimeAssert) assertThat(actual.getLastTransitionTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastTransitionTime"));
  }


  /**
   * Navigates to the property message so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert message()  {
    // check that actual CustomResourceDefinitionCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMessage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "message"));
  }


  /**
   * Navigates to the property reason so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert reason()  {
    // check that actual CustomResourceDefinitionCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getReason()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reason"));
  }


  /**
   * Navigates to the property status so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert status()  {
    // check that actual CustomResourceDefinitionCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStatus()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "status"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual CustomResourceDefinitionCondition we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
