package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link PodTemplate} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodTemplateAssert<S extends AbstractPodTemplateAssert<S, A>, A extends PodTemplate> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodTemplateAssert}</code> to make assertions on actual PodTemplate.
   * @param actual the PodTemplate we want to make assertions on.
   */
  protected AbstractPodTemplateAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PodTemplate we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual PodTemplate we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual PodTemplate we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public ObjectMetaAssert metadata()  {
    // check that actual PodTemplate we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property template so that assertions can be done on it
   */
  public PodTemplateSpecAssert template()  {
    // check that actual PodTemplate we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PodTemplateSpecAssert) assertThat(actual.getTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "template"));
  }


}
