package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link RoutePort} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRoutePortAssert<S extends AbstractRoutePortAssert<S, A>, A extends RoutePort> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRoutePortAssert}</code> to make assertions on actual RoutePort.
   * @param actual the RoutePort we want to make assertions on.
   */
  protected AbstractRoutePortAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual RoutePort we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property targetPort so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.IntOrStringAssert targetPort()  {
    // check that actual RoutePort we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.IntOrStringAssert) assertThat(actual.getTargetPort()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "targetPort"));
  }


}
