package io.fabric8.kubernetes.api.model.apiextensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link CustomResourceDefinitionSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomResourceDefinitionSpecAssert<S extends AbstractCustomResourceDefinitionSpecAssert<S, A>, A extends CustomResourceDefinitionSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomResourceDefinitionSpecAssert}</code> to make assertions on actual CustomResourceDefinitionSpec.
   * @param actual the CustomResourceDefinitionSpec we want to make assertions on.
   */
  protected AbstractCustomResourceDefinitionSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CustomResourceDefinitionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property group so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert group()  {
    // check that actual CustomResourceDefinitionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGroup()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "group"));
  }


  /**
   * Navigates to the property names so that assertions can be done on it
   */
  public CustomResourceDefinitionNamesAssert names()  {
    // check that actual CustomResourceDefinitionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CustomResourceDefinitionNamesAssert) assertThat(actual.getNames()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "names"));
  }


  /**
   * Navigates to the property scope so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert scope()  {
    // check that actual CustomResourceDefinitionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getScope()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scope"));
  }


  /**
   * Navigates to the property version so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert version()  {
    // check that actual CustomResourceDefinitionSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "version"));
  }


}
