package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Toleration} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTolerationAssert<S extends AbstractTolerationAssert<S, A>, A extends Toleration> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTolerationAssert}</code> to make assertions on actual Toleration.
   * @param actual the Toleration we want to make assertions on.
   */
  protected AbstractTolerationAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Toleration we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property effect so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert effect()  {
    // check that actual Toleration we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getEffect()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "effect"));
  }


  /**
   * Navigates to the property key so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert key()  {
    // check that actual Toleration we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKey()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "key"));
  }


  /**
   * Navigates to the property operator so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert operator()  {
    // check that actual Toleration we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getOperator()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "operator"));
  }


  /**
   * Navigates to the property value so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert value()  {
    // check that actual Toleration we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getValue()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "value"));
  }


}
