package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ServiceAccountRestriction} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractServiceAccountRestrictionAssert<S extends AbstractServiceAccountRestrictionAssert<S, A>, A extends ServiceAccountRestriction> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractServiceAccountRestrictionAssert}</code> to make assertions on actual ServiceAccountRestriction.
   * @param actual the ServiceAccountRestriction we want to make assertions on.
   */
  protected AbstractServiceAccountRestrictionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ServiceAccountRestriction we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property namespaces so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> namespaces()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getNamespaces(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespaces"));
    return answer;
  }


  /**
   * Navigates to the property serviceaccounts so that assertions can be done on it
   */
  public NavigationListAssert<ServiceAccountReference, ServiceAccountReferenceAssert> serviceaccounts()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ServiceAccountReference, ServiceAccountReferenceAssert> assertFactory = new AssertFactory<ServiceAccountReference, ServiceAccountReferenceAssert>() {
      public ServiceAccountReferenceAssert createAssert(ServiceAccountReference t) {
        return (ServiceAccountReferenceAssert) assertThat(t);
      }
    };
    NavigationListAssert<ServiceAccountReference, ServiceAccountReferenceAssert> answer = new NavigationListAssert<ServiceAccountReference, ServiceAccountReferenceAssert>(actual.getServiceaccounts(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceaccounts"));
    return answer;
  }


}
