package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link BuildTriggerPolicy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildTriggerPolicyAssert<S extends AbstractBuildTriggerPolicyAssert<S, A>, A extends BuildTriggerPolicy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildTriggerPolicyAssert}</code> to make assertions on actual BuildTriggerPolicy.
   * @param actual the BuildTriggerPolicy we want to make assertions on.
   */
  protected AbstractBuildTriggerPolicyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual BuildTriggerPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property generic so that assertions can be done on it
   */
  public WebHookTriggerAssert generic()  {
    // check that actual BuildTriggerPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (WebHookTriggerAssert) assertThat(actual.getGeneric()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "generic"));
  }


  /**
   * Navigates to the property github so that assertions can be done on it
   */
  public WebHookTriggerAssert github()  {
    // check that actual BuildTriggerPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (WebHookTriggerAssert) assertThat(actual.getGithub()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "github"));
  }


  /**
   * Navigates to the property imageChange so that assertions can be done on it
   */
  public ImageChangeTriggerAssert imageChange()  {
    // check that actual BuildTriggerPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ImageChangeTriggerAssert) assertThat(actual.getImageChange()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageChange"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual BuildTriggerPolicy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
