package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link StatefulSetSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStatefulSetSpecAssert<S extends AbstractStatefulSetSpecAssert<S, A>, A extends StatefulSetSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStatefulSetSpecAssert}</code> to make assertions on actual StatefulSetSpec.
   * @param actual the StatefulSetSpec we want to make assertions on.
   */
  protected AbstractStatefulSetSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual StatefulSetSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual StatefulSetSpec's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual StatefulSetSpec's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatefulSetSpec's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual StatefulSetSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property selector so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LabelSelectorAssert selector()  {
    // check that actual StatefulSetSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LabelSelectorAssert) assertThat(actual.getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"));
  }


  /**
   * Navigates to the property serviceName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert serviceName()  {
    // check that actual StatefulSetSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getServiceName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceName"));
  }


  /**
   * Navigates to the property template so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.PodTemplateSpecAssert template()  {
    // check that actual StatefulSetSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.PodTemplateSpecAssert) assertThat(actual.getTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "template"));
  }


  /**
   * Navigates to the property volumeClaimTemplates so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.PersistentVolumeClaim, io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert> volumeClaimTemplates()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.PersistentVolumeClaim, io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.PersistentVolumeClaim, io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert>() {
      public io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert createAssert(io.fabric8.kubernetes.api.model.PersistentVolumeClaim t) {
        return (io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.PersistentVolumeClaim, io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.PersistentVolumeClaim, io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert>(actual.getVolumeClaimTemplates(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumeClaimTemplates"));
    return answer;
  }


}
