/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableTagEvent;
import io.fabric8.openshift.api.model.TagEvent;
import io.fabric8.openshift.api.model.TagEventFluent;
import io.fabric8.openshift.api.model.TagEventFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class TagEventBuilder
extends TagEventFluentImpl<TagEventBuilder>
implements VisitableBuilder<TagEvent, TagEventBuilder> {
    TagEventFluent<?> fluent;

    public TagEventBuilder() {
        this(new TagEvent());
    }

    public TagEventBuilder(TagEventFluent<?> fluent) {
        this(fluent, new TagEvent());
    }

    public TagEventBuilder(TagEventFluent<?> fluent, TagEvent instance) {
        this.fluent = fluent;
        fluent.withCreated(instance.getCreated());
        fluent.withDockerImageReference(instance.getDockerImageReference());
        fluent.withGeneration(instance.getGeneration());
        fluent.withImage(instance.getImage());
    }

    public TagEventBuilder(TagEvent instance) {
        this.fluent = this;
        this.withCreated(instance.getCreated());
        this.withDockerImageReference(instance.getDockerImageReference());
        this.withGeneration(instance.getGeneration());
        this.withImage(instance.getImage());
    }

    public EditableTagEvent build() {
        EditableTagEvent buildable = new EditableTagEvent(this.fluent.getCreated(), this.fluent.getDockerImageReference(), this.fluent.getGeneration(), this.fluent.getImage());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TagEventBuilder that = (TagEventBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

