/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.ConfigMap;
import io.fabric8.kubernetes.api.model.extensions.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.extensions.ConfigMapFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.EditableConfigMap;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ConfigMapBuilder
extends ConfigMapFluentImpl<ConfigMapBuilder>
implements VisitableBuilder<ConfigMap, ConfigMapBuilder> {
    ConfigMapFluent<?> fluent;

    public ConfigMapBuilder() {
        this(new ConfigMap());
    }

    public ConfigMapBuilder(ConfigMapFluent<?> fluent) {
        this(fluent, new ConfigMap());
    }

    public ConfigMapBuilder(ConfigMapFluent<?> fluent, ConfigMap instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withData(instance.getData());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
    }

    public ConfigMapBuilder(ConfigMap instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withData(instance.getData());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    public EditableConfigMap build() {
        EditableConfigMap buildable = new EditableConfigMap(this.fluent.getApiVersion(), this.fluent.getData(), this.fluent.getKind(), this.fluent.getMetadata());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapBuilder that = (ConfigMapBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

