/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.ContainerImage;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractContainerImageAssert<S extends AbstractContainerImageAssert<S, A>, A extends ContainerImage>
extends AbstractAssert<S, A> {
    protected AbstractContainerImageAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((ContainerImage)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractContainerImageAssert)this.myself));
    }

    public S hasRepoTags(String ... repoTags) {
        this.isNotNull();
        if (repoTags == null) {
            this.failWithMessage("Expecting repoTags parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((ContainerImage)this.actual).getRepoTags(), (Object[])repoTags);
        return (S)((Object)((AbstractContainerImageAssert)this.myself));
    }

    public S hasOnlyRepoTags(String ... repoTags) {
        this.isNotNull();
        if (repoTags == null) {
            this.failWithMessage("Expecting repoTags parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((ContainerImage)this.actual).getRepoTags(), (Object[])repoTags);
        return (S)((Object)((AbstractContainerImageAssert)this.myself));
    }

    public S doesNotHaveRepoTags(String ... repoTags) {
        this.isNotNull();
        if (repoTags == null) {
            this.failWithMessage("Expecting repoTags parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((ContainerImage)this.actual).getRepoTags(), (Object[])repoTags);
        return (S)((Object)((AbstractContainerImageAssert)this.myself));
    }

    public S hasNoRepoTags() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have repoTags but had :\n  <%s>";
        if (((ContainerImage)this.actual).getRepoTags().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ContainerImage)this.actual).getRepoTags()});
        }
        return (S)((Object)((AbstractContainerImageAssert)this.myself));
    }

    public S hasSize(Long size) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting size of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualSize = ((ContainerImage)this.actual).getSize();
        if (!Objects.areEqual((Object)actualSize, (Object)size)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, size, actualSize});
        }
        return (S)((Object)((AbstractContainerImageAssert)this.myself));
    }
}

